/**
 * $Id$
 * 
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 * 
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.api.probing;

import io.sarl.lang.core.annotation.DefaultValue;
import io.sarl.lang.core.annotation.DefaultValueSource;
import io.sarl.lang.core.annotation.DefaultValueUse;
import io.sarl.lang.core.annotation.SarlElementType;
import io.sarl.lang.core.annotation.SarlSourceCode;
import io.sarl.lang.core.annotation.SarlSpecification;
import io.sarl.lang.core.annotation.SyntheticMember;
import java.net.URI;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

/**
 * Probe implementation.
 * 
 * @param <T> the type of value that is obtained by the probe.
 * @author <a href="http://www.ciad-lab.fr/stephane_galland">St&eacute;phane Galland</a>
 * @version api.probing 0.15.1 20250911-224825
 * @mavengroupid io.sarl.sdk
 * @mavenartifactid api.probing
 * @since 0.12
 */
@SarlSpecification("0.15")
@SarlElementType(11)
@XbaseGenerated
@SuppressWarnings("all")
public interface Probe<T extends Object> {
  /**
   * Replies the name of the probe
   */
  @Pure
  String getName();

  /**
   * Replies the probed component.
   */
  @Pure
  URI getUri();

  /**
   * Replies the probed value.
   */
  @Pure
  T getValue();

  /**
   * The type of the value.
   */
  @Pure
  Class<T> getType();

  /**
   * Change the probed value.
   * 
   * @param v the new value.
   */
  void setValue(final T v);

  /**
   * Force the synchronization of the probed value.
   * 
   * <p>The synchronization does nothing if the probe is {@link #isActive() inactive}.
   * 
   * @param forceReading indicates if the reading of the probed value must be forced from the probed element.
   *     By default, the value of this parameter is {@code true}.
   * @param forceIfInactiveObject indicates if the synchronization must be done even if the probe is inactive;
   *     By default, the value of this parameter is {@code false}.
   */
  @DefaultValueSource
  void sync(@DefaultValue("io.sarl.api.probing.Probe#SYNC_0") final boolean forceReading, @DefaultValue("io.sarl.api.probing.Probe#SYNC_1") final boolean forceIfInactiveObject);

  /**
   * Releases any resource associated to the probe.
   */
  void release();

  /**
   * Add listener on probe changes.
   */
  void addProbeListener(final IProbeListener listener);

  /**
   * Remove listener on probe changes.
   */
  void removeProbeListener(final IProbeListener listener);

  /**
   * Add listener on probe release.
   */
  void addProbeReleaseListener(final IProbeReleaseListener listener);

  /**
   * Remove listener on probe release.
   */
  void removeProbeReleaseListener(final IProbeReleaseListener listener);

  /**
   * Replies if this probe is active. When a probe is active, it could
   * be synchronized to the probed element.
   * 
   * @return {@code true} if the probe is active.
   */
  @Pure
  boolean isActive();

  /**
   * Replies if this probe is invalid. When a probe is invalid,
   * the exhibited value may not corresponds to the probed element's value.
   * 
   * @return {@code true} if the probe is invalid.
   */
  @Pure
  boolean isInvalid();

  /**
   * Default value for the parameter forceReading
   */
  @Pure
  @SyntheticMember
  @SarlSourceCode("true")
  default boolean $DEFAULT_VALUE$SYNC_0() {
    return true;
  }

  /**
   * Default value for the parameter forceIfInactiveObject
   */
  @Pure
  @SyntheticMember
  @SarlSourceCode("false")
  default boolean $DEFAULT_VALUE$SYNC_1() {
    return false;
  }

  /**
   * Force the synchronization of the probed value.
   * 
   * <p>The synchronization does nothing if the probe is {@link #isActive() inactive}.
   * 
   * @optionalparam forceReading indicates if the reading of the probed value must be forced from the probed element.
   *     By default, the value of this parameter is {@code true}.
   * @optionalparam forceIfInactiveObject indicates if the synchronization must be done even if the probe is inactive;
   *     By default, the value of this parameter is {@code false}.
   */
  @DefaultValueUse("boolean,boolean")
  @SyntheticMember
  default void sync() {
    sync($DEFAULT_VALUE$SYNC_0(), $DEFAULT_VALUE$SYNC_1());
  }

  /**
   * Force the synchronization of the probed value.
   * 
   * <p>The synchronization does nothing if the probe is {@link #isActive() inactive}.
   * 
   * @param forceReading indicates if the reading of the probed value must be forced from the probed element.
   *     By default, the value of this parameter is {@code true}.
   * @optionalparam forceIfInactiveObject indicates if the synchronization must be done even if the probe is inactive;
   *     By default, the value of this parameter is {@code false}.
   */
  @DefaultValueUse("boolean,boolean")
  @SyntheticMember
  default void sync(final boolean forceReading) {
    sync(forceReading, $DEFAULT_VALUE$SYNC_1());
  }
}
