/**
 * $Id$
 * 
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 * 
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.api.probing;

import io.sarl.api.naming.name.SarlName;
import io.sarl.lang.core.annotation.DefaultValue;
import io.sarl.lang.core.annotation.DefaultValueSource;
import io.sarl.lang.core.annotation.DefaultValueUse;
import io.sarl.lang.core.annotation.SarlElementType;
import io.sarl.lang.core.annotation.SarlSourceCode;
import io.sarl.lang.core.annotation.SarlSpecification;
import io.sarl.lang.core.annotation.SyntheticMember;
import java.net.URI;
import java.util.Collection;
import org.arakhne.afc.services.IService;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

/**
 * This service provides probing mechanisms.
 * 
 * @author <a href="http://www.ciad-lab.fr/stephane_galland">St&eacute;phane Galland</a>
 * @version api.probing 0.15.1 20250911-224825
 * @mavengroupid io.sarl.sdk
 * @mavenartifactid api.probing
 * @since 0.12
 */
@SarlSpecification("0.15")
@SarlElementType(11)
@XbaseGenerated
@SuppressWarnings("all")
public interface ProbeService extends IService {
  /**
   * Create a probe.
   * 
   * <p>If a probe with the same name name exists, a composed probe with the probe name is created with
   * the probes as composite.
   * 
   * @param valueName the probed element.
   * @param valueType the expected type of the value.
   * @param probeName is the optional name of the probe.
   */
  @DefaultValueSource
  <T extends Object> Probe<T> probe(final SarlName valueName, final Class<T> valueType, @DefaultValue("io.sarl.api.probing.ProbeService#PROBE_0") final String probeName);

  /**
   * Create a probe.
   * 
   * <p>If a probe with the same name name exists, a composed probe with the probe name is created with
   * the probes as composite.
   * 
   * @param valueName the probed element.
   * @param valueType the expected type of the value.
   * @param probeName is the optional name of the probe.
   */
  @DefaultValueSource
  <T extends Object> Probe<T> probe(final URI valueName, final Class<T> valueType, @DefaultValue("io.sarl.api.probing.ProbeService#PROBE_1") final String probeName);

  /**
   * Create a probe.
   * 
   * <p>If a probe with the same name name exists, a composed probe with the probe name is created with
   * the probes as composite.
   * 
   * @param valueName the probed element.
   * @param valueType the expected type of the value.
   * @param probeName is the optional name of the probe.
   */
  @DefaultValueSource
  <T extends Object> Probe<T> probe(final String valueName, final Class<T> valueType, @DefaultValue("io.sarl.api.probing.ProbeService#PROBE_2") final String probeName);

  /**
   * Replies all the probes.
   * 
   *  @return the iterable on probes
   */
  @Pure
  Collection<Probe<?>> getProbes();

  /**
   * Release all the probes.
   */
  void releaseAllProbes();

  /**
   * Force the synchronization of the probes.
   */
  void sync();

  /**
   * Default value for the parameter probeName
   */
  @Pure
  @SyntheticMember
  @SarlSourceCode("null")
  default String $DEFAULT_VALUE$PROBE_0() {
    return null;
  }

  /**
   * Default value for the parameter probeName
   */
  @Pure
  @SyntheticMember
  @SarlSourceCode("null")
  default String $DEFAULT_VALUE$PROBE_1() {
    return null;
  }

  /**
   * Default value for the parameter probeName
   */
  @Pure
  @SyntheticMember
  @SarlSourceCode("null")
  default String $DEFAULT_VALUE$PROBE_2() {
    return null;
  }

  /**
   * Create a probe.
   * 
   * <p>If a probe with the same name name exists, a composed probe with the probe name is created with
   * the probes as composite.
   * 
   * @param valueName the probed element.
   * @param valueType the expected type of the value.
   * @optionalparam probeName is the optional name of the probe.
   */
  @DefaultValueUse("io.sarl.api.naming.name.SarlName,java.lang.Class,java.lang.String")
  @SyntheticMember
  default <T extends Object> Probe<T> probe(final SarlName valueName, final Class<T> valueType) {
    return (io.sarl.api.probing.Probe<T>)probe(valueName, valueType, $DEFAULT_VALUE$PROBE_0());
  }

  /**
   * Create a probe.
   * 
   * <p>If a probe with the same name name exists, a composed probe with the probe name is created with
   * the probes as composite.
   * 
   * @param valueName the probed element.
   * @param valueType the expected type of the value.
   * @optionalparam probeName is the optional name of the probe.
   */
  @DefaultValueUse("java.net.URI,java.lang.Class,java.lang.String")
  @SyntheticMember
  default <T extends Object> Probe<T> probe(final URI valueName, final Class<T> valueType) {
    return (io.sarl.api.probing.Probe<T>)probe(valueName, valueType, $DEFAULT_VALUE$PROBE_1());
  }

  /**
   * Create a probe.
   * 
   * <p>If a probe with the same name name exists, a composed probe with the probe name is created with
   * the probes as composite.
   * 
   * @param valueName the probed element.
   * @param valueType the expected type of the value.
   * @optionalparam probeName is the optional name of the probe.
   */
  @DefaultValueUse("java.lang.String,java.lang.Class,java.lang.String")
  @SyntheticMember
  default <T extends Object> Probe<T> probe(final String valueName, final Class<T> valueType) {
    return (io.sarl.api.probing.Probe<T>)probe(valueName, valueType, $DEFAULT_VALUE$PROBE_2());
  }
}
