/**
 * $Id$
 * 
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 * 
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.api.workingmemory;

import io.sarl.api.naming.name.ScopedDataName;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.Skill;
import io.sarl.lang.core.annotation.SarlElementType;
import io.sarl.lang.core.annotation.SarlSpecification;
import io.sarl.lang.core.annotation.SyntheticMember;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

/**
 * Abstract skill to access to the agent working memory.
 * 
 * @author <a href="https://github.com/stefanotedeschi">Stefano Tedeschi</a>
 * @author <a href="http://www.ciad-lab.fr/stephane_galland">St&eacute;phane Galland</a>
 * @version api.workingmemory 0.15.1 20250911-224825
 * @mavengroupid io.sarl.sdk
 * @mavenartifactid api.workingmemory
 * @since 0.15
 */
@SarlSpecification("0.15")
@SarlElementType(22)
@XbaseGenerated
@SuppressWarnings("all")
public abstract class AbstractWorkingMemory extends Skill implements WorkingMemory {
  @Pure
  @Override
  public Object getKnowledge(final ScopedDataName id) throws KnowledgeMissingException {
    return this.<Object>getKnowledge(id, null);
  }

  @Pure
  @Override
  public List<ScopedDataName> getDefinedListForName(final String name) {
    return this.getDefinedForName(name).collect(Collectors.<ScopedDataName>toList());
  }

  @Pure
  @Override
  public Iterable<ScopedDataName> getDefinedNameList() {
    final Iterable<ScopedDataName> _function = () -> {
      return this.getDefinedNames().iterator();
    };
    return _function;
  }

  @Pure
  @Override
  public boolean isMemoryEmpty() {
    long _memorySize = this.getMemorySize();
    return (_memorySize == 0l);
  }

  @Pure
  @Override
  public Object getWorkingMemoryLock() {
    return this;
  }

  @SyntheticMember
  public AbstractWorkingMemory() {
    super();
  }

  @SyntheticMember
  public AbstractWorkingMemory(final Agent arg0) {
    super(arg0);
  }
}
