/**
 * $Id$
 * 
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 * 
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.api.workingmemory;

import io.sarl.lang.core.annotation.SarlElementType;
import io.sarl.lang.core.annotation.SarlSpecification;
import io.sarl.lang.core.annotation.SyntheticMember;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

/**
 * Exception that is thrown when a knowledge is unknown in the current
 * working memory.
 * 
 * @author <a href="https://github.com/stefanotedeschi">Stefano Tedeschi</a>
 * @author <a href="http://www.ciad-lab.fr/stephane_galland">St&eacute;phane Galland</a>
 * @version api.workingmemory 0.15.1 20250911-224825
 * @mavengroupid io.sarl.sdk
 * @mavenartifactid api.workingmemory
 * @since 0.15
 */
@SarlSpecification("0.15")
@SarlElementType(10)
@XbaseGenerated
@SuppressWarnings("all")
public class KnowledgeMissingException extends Exception {
  @SyntheticMember
  public KnowledgeMissingException() {
    super();
  }

  @SyntheticMember
  public KnowledgeMissingException(final String arg0) {
    super(arg0);
  }

  @SyntheticMember
  public KnowledgeMissingException(final Throwable arg0) {
    super(arg0);
  }

  @SyntheticMember
  public KnowledgeMissingException(final String arg0, final Throwable arg1) {
    super(arg0, arg1);
  }

  @SyntheticMember
  public KnowledgeMissingException(final String arg0, final Throwable arg1, final boolean arg2, final boolean arg3) {
    super(arg0, arg1, arg2, arg3);
  }

  @SyntheticMember
  private static final long serialVersionUID = 1L;
}
