/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.api.workingmemory;

import io.sarl.api.naming.name.ScopedDataName;
import io.sarl.api.workingmemory.DictionaryWorkingMemory;
import io.sarl.api.workingmemory.KnowledgeMissingException;
import io.sarl.lang.core.AgentTrait;
import io.sarl.lang.core.Capacity;
import io.sarl.lang.core.DefaultSkill;
import io.sarl.lang.core.annotation.SarlElementType;
import io.sarl.lang.core.annotation.SarlSpecification;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

@DefaultSkill(value=DictionaryWorkingMemory.class)
@SarlSpecification(value="0.15")
@SarlElementType(value=20)
@XbaseGenerated
public interface WorkingMemory
extends Capacity {
    @Pure
    public boolean isNullAllowedInMemory();

    public void setNullAllowedInMemory(boolean var1);

    @Pure
    public <T> T getKnowledge(ScopedDataName var1, Class<T> var2) throws KnowledgeMissingException;

    @Pure
    public Object getKnowledge(ScopedDataName var1) throws KnowledgeMissingException;

    public Object setKnowledge(ScopedDataName var1, Object var2);

    public void setKnowledgeIfAbsent(ScopedDataName var1, Object var2);

    public Object setKnowledgeIfPresent(ScopedDataName var1, Object var2);

    @Pure
    public Stream<ScopedDataName> getDefinedForName(String var1);

    @Pure
    public List<ScopedDataName> getDefinedListForName(String var1);

    @Pure
    public boolean isDefined(ScopedDataName var1);

    public Object removeKnowledge(ScopedDataName var1);

    public void removeNullValuedKnowledges();

    @Pure
    public Object getWorkingMemoryLock();

    @Pure
    public Stream<ScopedDataName> getDefinedNames();

    @Pure
    public Iterable<ScopedDataName> getDefinedNameList();

    @Pure
    public long getMemorySize();

    @Pure
    public boolean isMemoryEmpty();

    public void clearMemory();

    public static class ContextAwareCapacityWrapper<C extends WorkingMemory>
    extends Capacity.ContextAwareCapacityWrapper<C>
    implements WorkingMemory {
        public ContextAwareCapacityWrapper(C capacity, AgentTrait caller) {
            super(capacity, caller);
        }

        @Override
        public boolean isNullAllowedInMemory() {
            try {
                this.ensureCallerInLocalThread();
                boolean bl = ((WorkingMemory)this.capacity).isNullAllowedInMemory();
                return bl;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public void setNullAllowedInMemory(boolean enable) {
            try {
                this.ensureCallerInLocalThread();
                ((WorkingMemory)this.capacity).setNullAllowedInMemory(enable);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T getKnowledge(ScopedDataName id, Class<T> type) throws KnowledgeMissingException {
            try {
                this.ensureCallerInLocalThread();
                T t = ((WorkingMemory)this.capacity).getKnowledge(id, type);
                return t;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public Object getKnowledge(ScopedDataName id) throws KnowledgeMissingException {
            try {
                this.ensureCallerInLocalThread();
                Object object = ((WorkingMemory)this.capacity).getKnowledge(id);
                return object;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object setKnowledge(ScopedDataName id, Object value) {
            try {
                this.ensureCallerInLocalThread();
                Object object = ((WorkingMemory)this.capacity).setKnowledge(id, value);
                return object;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public void setKnowledgeIfAbsent(ScopedDataName id, Object value) {
            try {
                this.ensureCallerInLocalThread();
                ((WorkingMemory)this.capacity).setKnowledgeIfAbsent(id, value);
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object setKnowledgeIfPresent(ScopedDataName id, Object value) {
            try {
                this.ensureCallerInLocalThread();
                Object object = ((WorkingMemory)this.capacity).setKnowledgeIfPresent(id, value);
                return object;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public Stream<ScopedDataName> getDefinedForName(String name) {
            try {
                this.ensureCallerInLocalThread();
                Stream<ScopedDataName> stream = ((WorkingMemory)this.capacity).getDefinedForName(name);
                return stream;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public List<ScopedDataName> getDefinedListForName(String name) {
            try {
                this.ensureCallerInLocalThread();
                List<ScopedDataName> list = ((WorkingMemory)this.capacity).getDefinedListForName(name);
                return list;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public boolean isDefined(ScopedDataName id) {
            try {
                this.ensureCallerInLocalThread();
                boolean bl = ((WorkingMemory)this.capacity).isDefined(id);
                return bl;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public Object removeKnowledge(ScopedDataName id) {
            try {
                this.ensureCallerInLocalThread();
                Object object = ((WorkingMemory)this.capacity).removeKnowledge(id);
                return object;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public void removeNullValuedKnowledges() {
            try {
                this.ensureCallerInLocalThread();
                ((WorkingMemory)this.capacity).removeNullValuedKnowledges();
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public Object getWorkingMemoryLock() {
            try {
                this.ensureCallerInLocalThread();
                Object object = ((WorkingMemory)this.capacity).getWorkingMemoryLock();
                return object;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public Stream<ScopedDataName> getDefinedNames() {
            try {
                this.ensureCallerInLocalThread();
                Stream<ScopedDataName> stream = ((WorkingMemory)this.capacity).getDefinedNames();
                return stream;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public Iterable<ScopedDataName> getDefinedNameList() {
            try {
                this.ensureCallerInLocalThread();
                Iterable<ScopedDataName> iterable = ((WorkingMemory)this.capacity).getDefinedNameList();
                return iterable;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public long getMemorySize() {
            try {
                this.ensureCallerInLocalThread();
                long l = ((WorkingMemory)this.capacity).getMemorySize();
                return l;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public boolean isMemoryEmpty() {
            try {
                this.ensureCallerInLocalThread();
                boolean bl = ((WorkingMemory)this.capacity).isMemoryEmpty();
                return bl;
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }

        @Override
        public void clearMemory() {
            try {
                this.ensureCallerInLocalThread();
                ((WorkingMemory)this.capacity).clearMemory();
            }
            finally {
                this.resetCallerInLocalThread();
            }
        }
    }
}

