/**
 * $Id$
 * 
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 * 
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.sre.janus.network.boot.configs;

import io.bootique.BQCoreModule;
import io.bootique.BQModule;
import io.bootique.config.ConfigurationFactory;
import io.bootique.di.Binder;
import io.bootique.di.Injector;
import io.bootique.di.Provides;
import io.bootique.meta.application.OptionMetadata;
import io.sarl.lang.core.annotation.SarlElementType;
import io.sarl.lang.core.annotation.SarlSpecification;
import io.sarl.lang.core.annotation.SyntheticMember;
import jakarta.inject.Singleton;
import java.text.MessageFormat;
import org.arakhne.afc.bootique.variables.VariableDecls;
import org.arakhne.afc.bootique.variables.VariableNames;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

/**
 * Module for creating and configuring the networking features of the SRE.
 * 
 * @author <a href="http://www.ciad-lab.fr/stephane_galland">St&eacute;phane Galland</a>
 * @version janus.network 3.0.15.1 20250911-224826
 * @mavengroupid io.sarl.sre.janus
 * @mavenartifactid janus.network
 * @since 0.12
 */
@SarlSpecification("0.15")
@SarlElementType(10)
@XbaseGenerated
@SuppressWarnings("all")
public class SreNetworkConfigModule implements BQModule {
  public static final String NETWORK_LONG_OPTION = "network";

  @Override
  public void configure(final Binder binder) {
    VariableDecls.extend(binder).declareVar(SreNetworkConfig.ENABLE_NAME);
    final String cpDescription = MessageFormat.format(Messages.SreNetworkConfigModule_1, Boolean.valueOf(SreNetworkConfig.DEFAULT_ENABLE_VALUE).toString(), 
      VariableNames.toEnvironmentVariableName(SreNetworkConfig.ENABLE_NAME));
    BQCoreModule.extend(binder).addOption(OptionMetadata.builder(SreNetworkConfigModule.NETWORK_LONG_OPTION, cpDescription).valueRequired(Messages.SreNetworkConfigModule_0).build()).mapConfigPath(SreNetworkConfigModule.NETWORK_LONG_OPTION, SreNetworkConfig.ENABLE_NAME);
    VariableDecls.extend(binder).declareVar(SreNetworkConfig.LOCAL_HAZELCAST_INSTANCE_NAME);
  }

  /**
   * Replies the instance of the network configuration.
   * 
   * @param configFactory accessor to the bootique factory.
   * @param injector the current injector.
   * @return the configuration accessor.
   */
  @Provides
  @Singleton
  public SreNetworkConfig provideSreNetworkConfig(final ConfigurationFactory configFactory, final Injector injector) {
    final SreNetworkConfig config = SreNetworkConfig.getConfiguration(configFactory);
    injector.injectMembers(config);
    return config;
  }

  @SyntheticMember
  public SreNetworkConfigModule() {
    super();
  }
}
