/**
 * $Id$
 * 
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 * 
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.sarl.sre.janus.network.boot.internal;

import com.hazelcast.logging.LogEvent;
import com.hazelcast.logging.LogListener;
import io.sarl.lang.core.annotation.Injectable;
import io.sarl.lang.core.annotation.SarlElementType;
import io.sarl.lang.core.annotation.SarlSpecification;
import io.sarl.lang.core.annotation.SyntheticMember;
import io.sarl.sre.janus.services.logging.LoggingService;
import jakarta.inject.Inject;
import java.text.MessageFormat;
import java.util.logging.Logger;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

/**
 * Log listener for Hazelcast.
 * 
 * @author <a href="http://www.ciad-lab.fr/nicolas_gaud">Nicolas Gaud</a>
 * @version janus.network 3.0.15.1 20250911-224826
 * @mavengroupid io.sarl.sre.janus
 * @mavenartifactid janus.network
 * @since 0.12
 */
@SarlSpecification("0.15")
@SarlElementType(10)
@Injectable
@XbaseGenerated
@SuppressWarnings("all")
public class HazelcastLogListener implements LogListener {
  /**
   * SRE Kernel logger
   */
  private Logger logger;

  @Inject
  public HazelcastLogListener(final LoggingService logger) {
    this.logger = logger.getKernelModuleLogger(Messages.HazelcastLogListener_1);
  }

  public void log(final LogEvent logEvent) {
    this.logger.log(logEvent.getLogRecord().getLevel(), 
      MessageFormat.format(Messages.HazelcastLogListener_0, logEvent.getMember(), logEvent.getLogRecord().getMessage()));
  }

  @Override
  @Pure
  @SyntheticMember
  public boolean equals(final Object obj) {
    return super.equals(obj);
  }

  @Override
  @Pure
  @SyntheticMember
  public int hashCode() {
    int result = super.hashCode();
    return result;
  }
}
