/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.sre.janus.network.boot.configs;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Strings;

public enum JoinMethod {
    MULTICAST,
    TCP_IP;


    @JsonCreator
    public static JoinMethod valueOfCaseInsensitive(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new NullPointerException("name is null");
        }
        try {
            JoinMethod type = JoinMethod.valueOf(name.toUpperCase());
            if (type != null) {
                return type;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        throw new IllegalArgumentException("illegal value for name: " + name);
    }

    @JsonValue
    public String toJsonString() {
        return this.name().toLowerCase();
    }

    public static JoinMethod getDefault() {
        return MULTICAST;
    }

    public static String getJsonLabels() {
        StringBuilder buffer = new StringBuilder();
        boolean first = true;
        for (JoinMethod type : JoinMethod.values()) {
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(type.toJsonString());
        }
        return buffer.toString();
    }
}

