/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.sre.janus.network.boot.configs;

import io.bootique.annotation.BQConfig;
import io.bootique.annotation.BQConfigProperty;
import io.bootique.config.ConfigurationFactory;
import io.sarl.lang.core.annotation.Injectable;
import io.sarl.lang.core.annotation.SarlElementType;
import io.sarl.lang.core.annotation.SarlSpecification;
import io.sarl.lang.core.annotation.SyntheticMember;
import io.sarl.sre.janus.boot.configs.SreConfig;
import io.sarl.sre.janus.network.boot.configs.JoinMethod;
import io.sarl.sre.janus.network.boot.configs.SreNetworkConfig$1$AssertEvaluator$;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

@BQConfig(value="Configuration for the SRE networking feature")
@SarlSpecification(value="0.15")
@SarlElementType(value=10)
@Injectable
@XbaseGenerated
public class SreNetworkConfig {
    public static final String DEFAULT_PROGRAM_NAME = "janusnode";
    public static final String PREFIX = "srenetwork";
    public static final String ENABLE_NAME = "srenetwork.enable";
    public static final boolean DEFAULT_ENABLE_VALUE = false;
    public static final String CLUSTER_NAME_NAME = "srenetwork.clusterName";
    public static final String CLUSTER_NAME_PREFIX = "io.sarl.sre-hazelcast-";
    public static final String DEFAULT_CLUSTER_NAME_VALUE = "";
    public static final String JOIN_METHOD_NAME = "srenetwork.joinMethod";
    public static final String PORT_AUTO_INCREMENT_NAME = "srenetwork.portAutoIncrement";
    public static final boolean DEFAULT_PORT_AUTO_INCREMENT_VALUE = true;
    public static final String MIN_CLUSTER_SIZE_NAME = "srenetwork.minClusterSize";
    public static final int DEFAULT_MIN_CLUSTER_SIZE_VALUE = 1;
    public static final String IP_LIST_CLUSTER = "srenetwork.clusterMemberIPs";
    public static final String DEFAULT_IP_LIST_CLUSTER = "127.0.0.1";
    public static final String LOCAL_HAZELCAST_INSTANCE_NAME = "srenetwork.localHazelcastInstance";
    public static final boolean DEFAULT_LOCAL_HAZELCAST_INSTANCE_VALUE = false;
    private static final String ZERO_TO_255 = "([01]?[0-9]{1,2}|2[0-4][0-9]|25[0-5])";
    private static final String IP_REGEXP = "([01]?[0-9]{1,2}|2[0-4][0-9]|25[0-5])\\.([01]?[0-9]{1,2}|2[0-4][0-9]|25[0-5])\\.([01]?[0-9]{1,2}|2[0-4][0-9]|25[0-5])\\.([01]?[0-9]{1,2}|2[0-4][0-9]|25[0-5])";
    private static final String IP_SEPARATOR_REGEXP = "[^0-9\\.]+";
    private static final String IP_SEPARATOR = ",";
    private boolean enable = false;
    private boolean localHazelcastInstance = false;
    private String clusterName;
    private JoinMethod joinMethod;
    private String memberList;
    private String[] memberListArray;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private boolean portAutoIncrement = true;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private int minClusterSize = 1;
    private SreConfig generalConfiguration;

    @Inject
    public SreNetworkConfig(SreConfig generalConfiguration) {
        this.generalConfiguration = generalConfiguration;
    }

    @Pure
    public boolean getEnable() {
        return this.enable;
    }

    @BQConfigProperty(value="Enable or disable the networking features.")
    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    @Pure
    public boolean getLocalHazelcastInstance() {
        return this.localHazelcastInstance;
    }

    @BQConfigProperty(value="Enable or disable the local Hazelcast instance.")
    public void setLocalHazelcastInstance(boolean enable) {
        this.localHazelcastInstance = enable;
    }

    @Pure
    public static String createStandardClusterName(UUID rootContextId) {
        return SreNetworkConfig.createStandardClusterName(rootContextId.toString());
    }

    @Pure
    public static String createStandardClusterName(String rootContextId) {
        return CLUSTER_NAME_PREFIX + rootContextId;
    }

    @Pure
    public String getClusterName() {
        String explicitName = this.clusterName;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)explicitName);
        if (_isNullOrEmpty) {
            UUID id = this.generalConfiguration.getBoot().getRootContextID();
            this.clusterName = explicitName = SreNetworkConfig.createStandardClusterName(id);
        }
        return explicitName;
    }

    @Pure
    public String getClusterMemberIPs() {
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this.memberList);
        if (_isNullOrEmpty) {
            this.memberList = DEFAULT_IP_LIST_CLUSTER;
        }
        return this.memberList;
    }

    @Pure
    public String[] getClusterMemberIPsArray() {
        if (this.memberListArray == null) {
            String[] _split;
            ArrayList list = CollectionLiterals.newArrayList();
            Pattern pattern = Pattern.compile(IP_REGEXP);
            for (String ip : _split = this.getClusterMemberIPs().trim().split(IP_SEPARATOR_REGEXP)) {
                Matcher matcher = pattern.matcher(ip);
                boolean _matches = matcher.matches();
                if (!_matches) continue;
                list.add(ip);
            }
            String[] tab = new String[list.size()];
            list.toArray(tab);
            this.memberListArray = tab;
        }
        return this.memberListArray;
    }

    @BQConfigProperty(value="Specify the list of the IP adresses for the members that are allowed to be in the cluster. This configuration is used only if the join method is configured to TCP/IP.")
    public String[] setClusterMemberIPs(String ips) {
        String[] _xblockexpression = null;
        this.memberList = ips;
        this.memberListArray = null;
        _xblockexpression = null;
        return _xblockexpression;
    }

    public String[] setClusterMemberIPsArray(String ... ips) {
        String[] _xblockexpression = null;
        StringBuilder buf = new StringBuilder();
        Pattern pattern = Pattern.compile(IP_REGEXP);
        ArrayList list = CollectionLiterals.newArrayList();
        for (String ip : ips) {
            Matcher matcher = pattern.matcher(ip);
            boolean _matches = matcher.matches();
            if (!_matches) continue;
            int _length = buf.length();
            if (_length > 0) {
                buf.append(IP_SEPARATOR);
            }
            buf.append(ip);
            list.add(ip);
        }
        this.memberList = buf.toString();
        String[] tab = new String[list.size()];
        list.toArray(tab);
        this.memberListArray = tab;
        _xblockexpression = tab;
        return _xblockexpression;
    }

    public static boolean validateClusterMemberIPsArray(String ips) {
        String[] ipsArray = ips.trim().split(IP_SEPARATOR_REGEXP);
        Pattern pattern = Pattern.compile(IP_REGEXP);
        for (String ip : ipsArray) {
            Matcher matcher = pattern.matcher(ip);
            boolean _matches = matcher.matches();
            if (_matches) continue;
            return false;
        }
        return true;
    }

    @BQConfigProperty(value="Name of the Hazelcast cluster. By default, this name is based on the identifier of the agent root context.")
    public void setClusterName(String name) {
        this.clusterName = name;
    }

    @Pure
    public JoinMethod getJoinMethod() {
        this.ensureJoinMethod();
        return this.joinMethod;
    }

    @BQConfigProperty(value="Specify the method for joining the Hazelcast cluster over the computer network")
    public void setJoinMethod(JoinMethod type) {
        this.joinMethod = type;
        this.ensureJoinMethod();
    }

    @BQConfigProperty(value="Specify the minimal number of nodes to wait for starting in the cluster before really launching the SARL Run-time Environment")
    public int setMinClusterSize(int clusterSize) {
        int _xifexpression = 0;
        if (clusterSize < 1) {
            this.minClusterSize = 1;
            _xifexpression = 1;
        } else {
            _xifexpression = this.minClusterSize = clusterSize;
        }
        return _xifexpression;
    }

    private void ensureJoinMethod() {
        if (this.joinMethod == null) {
            this.joinMethod = JoinMethod.getDefault();
        }
    }

    @BQConfigProperty(value="Enable or disable the auto-incrementation of the Hazelcast port numbers.")
    public void setPortAutoIncrement(boolean enable) {
        this.portAutoIncrement = enable;
    }

    @Pure
    public static SreNetworkConfig getConfiguration(ConfigurationFactory configFactory) {
        assert (new SreNetworkConfig$1$AssertEvaluator$((ConfigurationFactory)configFactory).$$result);
        SreNetworkConfig config = (SreNetworkConfig)configFactory.config(SreNetworkConfig.class, PREFIX);
        return config;
    }

    @Pure
    @SyntheticMember
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SreNetworkConfig other = (SreNetworkConfig)obj;
        if (other.enable != this.enable) {
            return false;
        }
        if (other.localHazelcastInstance != this.localHazelcastInstance) {
            return false;
        }
        if (!Objects.equals(this.clusterName, other.clusterName)) {
            return false;
        }
        if (!Objects.equals(this.memberList, other.memberList)) {
            return false;
        }
        if (other.portAutoIncrement != this.portAutoIncrement) {
            return false;
        }
        if (other.minClusterSize != this.minClusterSize) {
            return false;
        }
        return super.equals(obj);
    }

    @Pure
    @SyntheticMember
    public int hashCode() {
        int result = super.hashCode();
        int prime = 31;
        result = 31 * result + Boolean.hashCode(this.enable);
        result = 31 * result + Boolean.hashCode(this.localHazelcastInstance);
        result = 31 * result + Objects.hashCode(this.clusterName);
        result = 31 * result + Objects.hashCode(this.memberList);
        result = 31 * result + Boolean.hashCode(this.portAutoIncrement);
        result = 31 * result + Integer.hashCode(this.minClusterSize);
        return result;
    }

    @Pure
    public boolean isPortAutoIncrement() {
        return this.portAutoIncrement;
    }

    @Pure
    public int getMinClusterSize() {
        return this.minClusterSize;
    }
}

