/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.sre.janus.network.boot.internal;

import com.hazelcast.config.Config;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.logging.LogListener;
import io.bootique.BQModule;
import io.bootique.di.Binder;
import io.bootique.di.Injector;
import io.bootique.di.Provides;
import io.sarl.api.core.spaces.EventTransportService;
import io.sarl.api.core.spaces.LocalEventTransportService;
import io.sarl.apputils.bootiqueapp.config.LogConfig;
import io.sarl.lang.core.annotation.SarlElementType;
import io.sarl.lang.core.annotation.SarlSpecification;
import io.sarl.lang.core.annotation.SyntheticMember;
import io.sarl.sre.janus.network.boot.configs.JoinMethod;
import io.sarl.sre.janus.network.boot.configs.SreNetworkConfig;
import io.sarl.sre.janus.network.boot.internal.HazelcastLogListener;
import io.sarl.sre.janus.network.boot.internal.Messages;
import io.sarl.sre.janus.network.services.HazelcastContextService;
import io.sarl.sre.janus.network.services.HazelcastEventTransportService;
import io.sarl.sre.janus.network.services.HazelcastSpaceRepository;
import io.sarl.sre.janus.services.context.ContextService;
import io.sarl.sre.janus.services.context.LocalSpaceRepository;
import io.sarl.sre.janus.services.context.MemoryBasedContextService;
import io.sarl.sre.janus.services.context.SpaceRepository;
import io.sarl.sre.janus.services.logging.LoggingService;
import jakarta.inject.Singleton;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

@SarlSpecification(value="0.15")
@SarlElementType(value=10)
@XbaseGenerated
public class NetworkModule
implements BQModule {
    public void configure(Binder binder) {
    }

    @Provides
    @Pure
    public SpaceRepository provideSpaceRepository(Injector injector, SreNetworkConfig netConfig) {
        Class instanceType = null;
        boolean _enable = netConfig.getEnable();
        instanceType = _enable ? HazelcastSpaceRepository.class : LocalSpaceRepository.class;
        return (SpaceRepository)injector.getInstance(instanceType);
    }

    @Provides
    @Singleton
    @Pure
    public ContextService provideContextService(Injector injector, SreNetworkConfig netConfig) {
        Class instanceType = null;
        boolean _enable = netConfig.getEnable();
        instanceType = _enable ? HazelcastContextService.class : MemoryBasedContextService.class;
        return (ContextService)injector.getInstance(instanceType);
    }

    @Provides
    @Singleton
    @Pure
    public EventTransportService provideEventTransportService(Injector injector, SreNetworkConfig netConfig) {
        Class instanceType = null;
        boolean _enable = netConfig.getEnable();
        instanceType = _enable ? HazelcastEventTransportService.class : LocalEventTransportService.class;
        return (EventTransportService)injector.getInstance(instanceType);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @Singleton
    public HazelcastInstance provideHazelcastInstance(LoggingService logger, SreNetworkConfig netConfig, LogConfig logConfig) {
        Config config = new Config();
        String cname = netConfig.getClusterName();
        config.setClusterName(cname);
        Supplier<String> _function = () -> MessageFormat.format(Messages.NetworkModule_3, cname);
        logger.getKernelLogger().log(Level.FINE, _function);
        boolean _localHazelcastInstance = netConfig.getLocalHazelcastInstance();
        if (_localHazelcastInstance) {
            MulticastConfig _multicastConfig = config.getNetworkConfig().getJoin().getMulticastConfig();
            _multicastConfig.setEnabled(false);
            TcpIpConfig _tcpIpConfig = config.getNetworkConfig().getJoin().getTcpIpConfig();
            _tcpIpConfig.setEnabled(true);
            TcpIpConfig _tcpIpConfig_1 = config.getNetworkConfig().getJoin().getTcpIpConfig();
            _tcpIpConfig_1.setMembers(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"127.0.0.1"})));
        } else {
            void var13_22;
            JoinMethod jmethod = netConfig.getJoinMethod();
            Supplier<String> _function_1 = () -> MessageFormat.format(Messages.NetworkModule_4, new Object[]{jmethod});
            logger.getKernelLogger().log(Level.FINE, _function_1);
            if (jmethod == JoinMethod.MULTICAST) {
                MulticastConfig _multicastConfig_1 = config.getNetworkConfig().getJoin().getMulticastConfig();
                _multicastConfig_1.setEnabled(true);
                TcpIpConfig _tcpIpConfig_2 = config.getNetworkConfig().getJoin().getTcpIpConfig();
                _tcpIpConfig_2.setEnabled(false);
            } else {
                MulticastConfig _multicastConfig_2 = config.getNetworkConfig().getJoin().getMulticastConfig();
                _multicastConfig_2.setEnabled(false);
                TcpIpConfig _tcpIpConfig_3 = config.getNetworkConfig().getJoin().getTcpIpConfig();
                _tcpIpConfig_3.setEnabled(true);
                String[] iplist = netConfig.getClusterMemberIPsArray();
                if (iplist != null) {
                    Supplier<String> supplier = () -> MessageFormat.format(Messages.NetworkModule_5, Arrays.toString(iplist));
                    logger.getKernelLogger().log(Level.FINE, supplier);
                }
                for (String memberIp : iplist) {
                    config.getNetworkConfig().getJoin().getTcpIpConfig().addMember(memberIp);
                }
            }
            NetworkConfig _networkConfig = config.getNetworkConfig();
            _networkConfig.setPortAutoIncrement(netConfig.isPortAutoIncrement());
            int minNumber = netConfig.getMinClusterSize();
            config.setProperty("hazelcast.initial.min.cluster.size", Integer.valueOf(minNumber).toString());
            int otherNumber = minNumber - 1;
            Object var13_18 = null;
            if (otherNumber > 1) {
                String string = MessageFormat.format(Messages.NetworkModule_2, Integer.valueOf(otherNumber).toString());
            } else if (otherNumber > 0) {
                String string = MessageFormat.format(Messages.NetworkModule_1, Integer.valueOf(otherNumber).toString());
            } else {
                String string = Messages.NetworkModule_0;
            }
            logger.getKernelLogger().info((String)var13_22);
        }
        HazelcastInstance hzlInstance = Hazelcast.newHazelcastInstance((Config)config);
        HazelcastLogListener _hazelcastLogListener = new HazelcastLogListener(logger);
        hzlInstance.getLoggingService().addLogListener(logConfig.getLevel().toJul(), (LogListener)_hazelcastLogListener);
        return hzlInstance;
    }

    @SyntheticMember
    public NetworkModule() {
    }
}

