/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.sre.janus.network.services;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import com.hazelcast.map.MapEvent;
import com.hazelcast.map.listener.MapListener;
import io.bootique.di.Injector;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.annotation.Injectable;
import io.sarl.lang.core.annotation.SarlElementType;
import io.sarl.lang.core.annotation.SarlSpecification;
import io.sarl.lang.core.annotation.SyntheticMember;
import io.sarl.sre.janus.KernelScope;
import io.sarl.sre.janus.boot.configs.SreConfig;
import io.sarl.sre.janus.internal.Factories;
import io.sarl.sre.janus.network.services.Messages;
import io.sarl.sre.janus.services.context.Context;
import io.sarl.sre.janus.services.context.ContextFactory;
import io.sarl.sre.janus.services.context.MemoryBasedContextService;
import io.sarl.sre.janus.services.logging.LoggingService;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

@SarlSpecification(value="0.15")
@SarlElementType(value=10)
@Injectable
@XbaseGenerated
public class HazelcastContextService
extends MemoryBasedContextService {
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private HazelcastInstance hazelcastInstance;
    private IMap<UUID, UUID> defaultSpaces;
    private UUID defaultSpacesListenerID;

    @Inject
    public HazelcastContextService(SreConfig sreConfig, @KernelScope Context rootContext, LoggingService logger, Injector injector, ContextFactory factory, Provider<Factories> factories, HazelcastInstance hazelcastInstance) {
        super(rootContext, logger, injector, factory, factories);
        this.hazelcastInstance = hazelcastInstance;
        Supplier<String> _function = () -> Messages.HazelcastContextService_0;
        this.logger.info(_function);
        this.defaultSpaces = this.hazelcastInstance.getMap(sreConfig.getBoot().getRootContextID().toString());
        Supplier<String> _function_1 = () -> Messages.HazelcastContextService_1;
        this.logger.info(_function_1);
        this.defaultSpaces.putIfAbsent((Object)sreConfig.getBoot().getRootContextID(), (Object)sreConfig.getBoot().getRootSpaceID());
        Supplier<String> _function_2 = () -> Messages.HazelcastContextService_2;
        this.logger.info(_function_2);
        DefaultSpacesMapListener defaultSpacesListener = new DefaultSpacesMapListener(this);
        this.defaultSpacesListenerID = this.defaultSpaces.addEntryListener((MapListener)defaultSpacesListener, true);
        Supplier<String> _function_3 = () -> Messages.HazelcastContextService_3;
        this.logger.info(_function_3);
    }

    @Pure
    protected Logger createLogger(LoggingService loggingService) {
        return loggingService.getKernelModuleLogger(Messages.HazelcastContextService_9);
    }

    protected Context newContextInstance(UUID contextID, UUID defaultSpaceID, Agent owner) {
        Supplier<String> _function = () -> MessageFormat.format(Messages.HazelcastContextService_4, contextID, defaultSpaceID);
        this.logger.info(_function);
        this.defaultSpaces.putIfAbsent((Object)contextID, (Object)defaultSpaceID);
        return super.newContextInstance(contextID, defaultSpaceID, owner);
    }

    public Context removeContext(UUID contextID) {
        Context _xblockexpression = null;
        this.defaultSpaces.remove((Object)contextID);
        _xblockexpression = super.removeContext(contextID);
        return _xblockexpression;
    }

    public void onStart() {
        super.onStart();
    }

    protected Context ensureDefaultSpaceDefinition(UUID contextID, UUID defaultSpaceID, Agent owner) {
        Context _xblockexpression = null;
        Supplier<String> _function = () -> MessageFormat.format(Messages.HazelcastContextService_5, defaultSpaceID, contextID);
        this.logger.info(_function);
        Context _xifexpression = null;
        boolean _containsKey = this.getContextInternalStructure().containsKey(contextID);
        if (!_containsKey) {
            _xifexpression = super.createContext(contextID, defaultSpaceID, owner);
        } else {
            boolean _notEquals;
            UUID _iD = this.getContext(contextID).getDefaultSpace().getSpaceID().getID();
            boolean bl = _notEquals = !Objects.equals(_iD, defaultSpaceID);
            if (_notEquals) {
                Supplier<String> _function_1 = () -> MessageFormat.format(Messages.HazelcastContextService_6, defaultSpaceID, contextID);
                this.logger.severe(_function_1);
            }
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected Context removeDefaultSpaceDefinition(UUID contextID, UUID defaultSpaceID) {
        boolean _isPseudoEmpty;
        Context _xifexpression = null;
        boolean bl = _isPseudoEmpty = this.getContext(contextID).getDefaultSpace().getNumberOfStrongParticipants() == 0;
        if (_isPseudoEmpty) {
            Context _xifexpression_1 = null;
            UUID _iD = this.getContext(contextID).getDefaultSpace().getSpaceID().getID();
            if (_iD == defaultSpaceID) {
                Context _xblockexpression = null;
                Supplier<String> _function = () -> MessageFormat.format(Messages.HazelcastContextService_7, defaultSpaceID, contextID);
                this.logger.info(_function);
                _xifexpression_1 = _xblockexpression = super.removeContext(contextID);
            } else {
                Supplier<String> _function = () -> MessageFormat.format(Messages.HazelcastContextService_8, defaultSpaceID, contextID);
                this.logger.severe(_function);
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public void onStop() {
        super.onStop();
        this.defaultSpaces.clear();
        this.defaultSpaces.removeEntryListener(this.defaultSpacesListenerID);
        boolean _isRunning = this.hazelcastInstance.getLifecycleService().isRunning();
        if (_isRunning) {
            this.hazelcastInstance.shutdown();
        }
    }

    @Pure
    @SyntheticMember
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        HazelcastContextService other = (HazelcastContextService)((Object)obj);
        if (!Objects.equals(this.defaultSpacesListenerID, other.defaultSpacesListenerID)) {
            return false;
        }
        return super.equals(obj);
    }

    @Pure
    @SyntheticMember
    public int hashCode() {
        int result = super.hashCode();
        int prime = 31;
        result = 31 * result + Objects.hashCode(this.defaultSpacesListenerID);
        return result;
    }

    @Pure
    public HazelcastInstance getHazelcastInstance() {
        return this.hazelcastInstance;
    }

    @SarlSpecification(value="0.15")
    @SarlElementType(value=10)
    @XbaseGenerated
    protected static class DefaultSpacesMapListener
    implements EntryListener<UUID, UUID> {
        private HazelcastContextService hazelcastContextService;

        public DefaultSpacesMapListener(HazelcastContextService hazelcastContextService) {
            this.hazelcastContextService = hazelcastContextService;
        }

        public void entryAdded(EntryEvent<UUID, UUID> event) {
            this.hazelcastContextService.ensureDefaultSpaceDefinition((UUID)event.getKey(), (UUID)event.getValue(), null);
        }

        public void entryUpdated(EntryEvent<UUID, UUID> event) {
        }

        public void entryRemoved(EntryEvent<UUID, UUID> event) {
            this.hazelcastContextService.removeDefaultSpaceDefinition((UUID)event.getKey(), (UUID)event.getValue());
        }

        public void entryEvicted(EntryEvent<UUID, UUID> event) {
        }

        public void entryExpired(EntryEvent<UUID, UUID> event) {
        }

        public void mapCleared(MapEvent event) {
        }

        public void mapEvicted(MapEvent event) {
        }

        @Pure
        @SyntheticMember
        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        @Pure
        @SyntheticMember
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }
}

