/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.sre.janus.network.services;

import com.hazelcast.collection.ISet;
import com.hazelcast.collection.ItemEvent;
import com.hazelcast.collection.ItemListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.topic.ITopic;
import com.hazelcast.topic.Message;
import com.hazelcast.topic.MessageListener;
import io.sarl.api.core.spaces.AbstractEventSpace;
import io.sarl.api.core.spaces.EventTransportService;
import io.sarl.lang.core.Address;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.EventSpace;
import io.sarl.lang.core.Scope;
import io.sarl.lang.core.Space;
import io.sarl.lang.core.SpaceID;
import io.sarl.lang.core.annotation.Injectable;
import io.sarl.lang.core.annotation.SarlElementType;
import io.sarl.lang.core.annotation.SarlSpecification;
import io.sarl.lang.core.annotation.SyntheticMember;
import io.sarl.lang.core.util.ConcurrentCollection;
import io.sarl.sre.janus.network.services.Messages;
import io.sarl.sre.janus.services.context.Context;
import io.sarl.sre.janus.services.context.ContextService;
import io.sarl.sre.janus.services.logging.LoggingService;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

@Singleton
@SarlSpecification(value="0.15")
@SarlElementType(value=10)
@Injectable
@XbaseGenerated
public class HazelcastEventTransportService
implements EventTransportService {
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private HazelcastInstance hazelcastInstance;
    private ISet<String> availableTopicsName;
    private ConcurrentHashMap<String, UUID> topicListenerIDs;
    private ContextService contextService;
    private Logger kernelLogger;
    public static final String HAZELCAST_SARL_TOPICS_NAME_SET = "io.sarl.topics.distributedset";
    public static final String HAZELCAST_SARL_TOPICS_ROOTWILCARD = "io.sarl.topics.";

    @Inject
    public HazelcastEventTransportService(HazelcastInstance iHazelcastInstance, ContextService icontextService, LoggingService logger) {
        this.contextService = icontextService;
        this.hazelcastInstance = iHazelcastInstance;
        this.kernelLogger = logger.getKernelModuleLogger(Messages.HazelcastEventTransportService_1);
        ConcurrentHashMap _concurrentHashMap = new ConcurrentHashMap();
        this.topicListenerIDs = _concurrentHashMap;
        this.availableTopicsName = this.hazelcastInstance.getSet(HAZELCAST_SARL_TOPICS_NAME_SET);
        TopicNameListener _topicNameListener = new TopicNameListener(this.kernelLogger, this.hazelcastInstance, this.topicListenerIDs, this.contextService);
        this.availableTopicsName.addItemListener((ItemListener)_topicNameListener, true);
        String defaultSpaceRootContextTopicName = HazelcastEventTransportService.getTopicNameFromSpaceID(icontextService.getRootContext().getDefaultSpace().getSpaceID());
        this.availableTopicsName.add((Object)defaultSpaceRootContextTopicName);
        ITopic defaultSpaceRootContextTopic = this.hazelcastInstance.getReliableTopic(defaultSpaceRootContextTopicName);
        TopicMessageListener _topicMessageListener = new TopicMessageListener(this.kernelLogger, defaultSpaceRootContextTopicName, this.contextService);
        UUID listenerID = defaultSpaceRootContextTopic.addMessageListener((MessageListener)_topicMessageListener);
        this.topicListenerIDs.put(defaultSpaceRootContextTopicName, listenerID);
    }

    public boolean routeEvent(Event event, EventSpace space, Scope<? super Address> scope) {
        boolean _xblockexpression = false;
        String topicName = HazelcastEventTransportService.getTopicNameFromSpaceID(space.getSpaceID());
        ITopic spaceTopic = this.hazelcastInstance.getReliableTopic(topicName);
        this.kernelLogger.log(Level.INFO, MessageFormat.format(Messages.HazelcastEventTransportService_0, event.getClass(), space.getSpaceID().getID(), space.getSpaceID().getContextID(), topicName));
        TopicMessage _topicMessage = new TopicMessage(event, scope);
        spaceTopic.publish((Object)_topicMessage);
        _xblockexpression = true;
        return _xblockexpression;
    }

    @Pure
    public static String getTopicNameFromSpaceID(SpaceID spaceID) {
        UUID _contextID = spaceID.getContextID();
        UUID _iD = spaceID.getID();
        return "io.sarl.topics.space." + String.valueOf(_contextID) + "." + String.valueOf(_iD);
    }

    @Pure
    @SyntheticMember
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Pure
    @SyntheticMember
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Pure
    public HazelcastInstance getHazelcastInstance() {
        return this.hazelcastInstance;
    }

    @SarlSpecification(value="0.15")
    @SarlElementType(value=10)
    @XbaseGenerated
    protected static class TopicNameListener
    implements ItemListener<String> {
        private Logger kernelLogger;
        private HazelcastInstance hazelcastInstance;
        private ConcurrentHashMap<String, UUID> topicListenerIDs;
        private ContextService contextService;

        public TopicNameListener(Logger logger, HazelcastInstance hzl, ConcurrentHashMap<String, UUID> itopicListenerIDs, ContextService icontextService) {
            this.kernelLogger = logger;
            this.hazelcastInstance = hzl;
            this.topicListenerIDs = itopicListenerIDs;
            this.contextService = icontextService;
        }

        public void itemAdded(ItemEvent<String> newTopicName) {
            this.kernelLogger.log(Level.INFO, MessageFormat.format(Messages.TopicNameListener_0, newTopicName.getItem()));
            boolean _containsKey = this.topicListenerIDs.containsKey(newTopicName.getItem());
            if (!_containsKey) {
                this.kernelLogger.log(Level.INFO, MessageFormat.format(Messages.TopicNameListener_1, newTopicName.getItem()));
                ITopic topic = this.hazelcastInstance.getReliableTopic((String)newTopicName.getItem());
                String _item = (String)newTopicName.getItem();
                TopicMessageListener _topicMessageListener = new TopicMessageListener(this.kernelLogger, _item, this.contextService);
                UUID listenerID = topic.addMessageListener((MessageListener)_topicMessageListener);
                this.topicListenerIDs.put((String)newTopicName.getItem(), listenerID);
            }
        }

        public void itemRemoved(ItemEvent<String> removedTopicName) {
            this.kernelLogger.log(Level.INFO, MessageFormat.format(Messages.TopicNameListener_2, removedTopicName.getItem()));
            ITopic topic = this.hazelcastInstance.getReliableTopic((String)removedTopicName.getItem());
            UUID existingListenerID = this.topicListenerIDs.get(removedTopicName.getItem());
            topic.removeMessageListener(existingListenerID);
            this.topicListenerIDs.remove(existingListenerID);
        }

        @Pure
        @SyntheticMember
        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        @Pure
        @SyntheticMember
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }

    @SarlSpecification(value="0.15")
    @SarlElementType(value=10)
    @XbaseGenerated
    protected static class TopicMessageListener
    implements MessageListener<TopicMessage> {
        private Logger kernelLogger;
        private String listenTopicName;
        private ContextService contextService;

        public TopicMessageListener(Logger logger, String topicName, ContextService icontextService) {
            this.kernelLogger = logger;
            this.listenTopicName = topicName;
            this.contextService = icontextService;
        }

        public void onMessage(Message<TopicMessage> incomingMessage) {
            Event eventToDispatchLocally = ((TopicMessage)incomingMessage.getMessageObject()).transferredEvent;
            String contextUIIDString = this.listenTopicName.substring(21, 57);
            String spaceUIIDString = this.listenTopicName.substring(58, 94);
            UUID contextUUID = UUID.fromString(contextUIIDString);
            UUID spaceUIID = UUID.fromString(spaceUIIDString);
            Context context = this.contextService.getContext(contextUUID);
            if (context != null) {
                ConcurrentCollection _spaces = context.getSpaces();
                for (Space localSpace : _spaces) {
                    boolean _equals = localSpace.getSpaceID().getID().equals(spaceUIID);
                    if (!_equals) continue;
                    this.kernelLogger.log(Level.INFO, MessageFormat.format(Messages.TopicMessageListener_0, spaceUIID, contextUUID));
                    ((AbstractEventSpace)localSpace).emit(eventToDispatchLocally.getSource().getID(), eventToDispatchLocally, ((TopicMessage)incomingMessage.getMessageObject()).trasnferredScope);
                }
            } else {
                this.kernelLogger.log(Level.SEVERE, MessageFormat.format(Messages.TopicMessageListener_1, spaceUIID, contextUUID));
            }
        }

        @Pure
        @SyntheticMember
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TopicMessageListener other = (TopicMessageListener)obj;
            if (!Objects.equals(this.listenTopicName, other.listenTopicName)) {
                return false;
            }
            return super.equals(obj);
        }

        @Pure
        @SyntheticMember
        public int hashCode() {
            int result = super.hashCode();
            int prime = 31;
            result = 31 * result + Objects.hashCode(this.listenTopicName);
            return result;
        }
    }

    @SarlSpecification(value="0.15")
    @SarlElementType(value=10)
    @XbaseGenerated
    public static class TopicMessage
    implements Serializable {
        @Accessors
        private final Event transferredEvent;
        @Accessors
        private final Scope<? super Address> trasnferredScope;
        @SyntheticMember
        private static final long serialVersionUID = 510724359L;

        public TopicMessage(Event e, Scope<? super Address> s) {
            this.transferredEvent = e;
            this.trasnferredScope = s;
        }

        @Pure
        @SyntheticMember
        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        @Pure
        @SyntheticMember
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }

        @Pure
        public Event getTransferredEvent() {
            return this.transferredEvent;
        }

        @Pure
        public Scope<? super Address> getTrasnferredScope() {
            return this.trasnferredScope;
        }
    }
}

