/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.sre.janus.network.services;

import com.hazelcast.collection.ISet;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import com.hazelcast.map.MapEvent;
import com.hazelcast.map.listener.MapListener;
import io.bootique.di.Injector;
import io.sarl.lang.core.Space;
import io.sarl.lang.core.SpaceID;
import io.sarl.lang.core.SpaceSpecification;
import io.sarl.lang.core.annotation.DefaultValue;
import io.sarl.lang.core.annotation.DefaultValueSource;
import io.sarl.lang.core.annotation.DefaultValueUse;
import io.sarl.lang.core.annotation.Injectable;
import io.sarl.lang.core.annotation.SarlElementType;
import io.sarl.lang.core.annotation.SarlSourceCode;
import io.sarl.lang.core.annotation.SarlSpecification;
import io.sarl.lang.core.annotation.SyntheticMember;
import io.sarl.sre.janus.boot.configs.SreConfig;
import io.sarl.sre.janus.internal.Factories;
import io.sarl.sre.janus.network.services.HazelcastEventTransportService;
import io.sarl.sre.janus.network.services.HazelcastSpaceRepository$1$1$AssertEvaluator$;
import io.sarl.sre.janus.network.services.HazelcastSpaceRepository$1$2$AssertEvaluator$;
import io.sarl.sre.janus.network.services.HazelcastSpaceRepository$1$3$AssertEvaluator$;
import io.sarl.sre.janus.network.services.Messages;
import io.sarl.sre.janus.services.context.Context;
import io.sarl.sre.janus.services.context.ContextService;
import io.sarl.sre.janus.services.context.LocalSpaceRepository;
import io.sarl.sre.janus.services.context.SpaceRepository;
import io.sarl.sre.janus.services.executor.ExecutorService;
import io.sarl.sre.janus.services.logging.LoggingService;
import io.sarl.sre.janus.spaces.SreSpaceSpecificationFactory;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

@SarlSpecification(value="0.15")
@SarlElementType(value=10)
@Injectable
@XbaseGenerated
public class HazelcastSpaceRepository
extends LocalSpaceRepository {
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private HazelcastInstance hazelcastInstance;
    private IMap<SpaceID, Object[]> spaceIDs;
    private ContextService contextService;
    private UUID spaceIDsListernerID;
    private ISet<String> availableTopicsName;
    public static final String HAZELCAST_SPACE_ID_MAP_NAME = "io.sarl.network.distributedSpaceIDMapName";

    @DefaultValueSource
    @Inject
    public HazelcastSpaceRepository(Injector injector, ExecutorService executor, LoggingService loggingService, SreConfig config, SreSpaceSpecificationFactory specificationFactory, ContextService icontextService, Provider<Factories> factories, HazelcastInstance iHazelcastInstance, @DefaultValue(value="io.sarl.sre.janus.network.services.HazelcastSpaceRepository#NEW_0") Map<UUID, SpaceRepository.SpaceDescription> internalStructure0, @DefaultValue(value="io.sarl.sre.janus.network.services.HazelcastSpaceRepository#NEW_1") IMap<SpaceID, Object[]> internalStructure1) {
        super(injector, executor, loggingService, config, specificationFactory, internalStructure0, factories);
        IMap _map;
        this.contextService = icontextService;
        this.hazelcastInstance = iHazelcastInstance;
        this.logger.log(Level.INFO, Messages.HazelcastSpaceRepository_0);
        this.availableTopicsName = this.hazelcastInstance.getSet("io.sarl.topics.distributedset");
        IMap _elvis = null;
        _elvis = internalStructure1 != null ? internalStructure1 : (_map = this.hazelcastInstance.getMap(HAZELCAST_SPACE_ID_MAP_NAME));
        this.spaceIDs = _elvis;
        EntryListener<SpaceID, Object[]> spaceIDsListerner = new EntryListener<SpaceID, Object[]>(){

            public void entryAdded(EntryEvent<SpaceID, Object[]> event) {
                assert (new HazelcastSpaceRepository$1$1$AssertEvaluator$(this, event).$$result);
                HazelcastSpaceRepository.this.ensureLocalSpaceDefinition((SpaceID)event.getKey(), (Object[])event.getValue());
            }

            public void entryEvicted(EntryEvent<SpaceID, Object[]> event) {
                assert (new HazelcastSpaceRepository$1$2$AssertEvaluator$(this, event).$$result);
                HazelcastSpaceRepository.this.removeLocalSpaceDefinition((SpaceID)event.getKey(), false);
            }

            public void entryRemoved(EntryEvent<SpaceID, Object[]> event) {
                assert (new HazelcastSpaceRepository$1$3$AssertEvaluator$(this, event).$$result);
                HazelcastSpaceRepository.this.removeLocalSpaceDefinition((SpaceID)event.getKey(), false);
            }

            public void entryUpdated(EntryEvent<SpaceID, Object[]> event) {
            }

            public void mapCleared(MapEvent event) {
                HazelcastSpaceRepository.this.removeLocalSpaceDefinitions();
            }

            public void mapEvicted(MapEvent event) {
            }

            public void entryExpired(EntryEvent<SpaceID, Object[]> event) {
            }
        };
        this.spaceIDsListernerID = this.spaceIDs.addEntryListener((MapListener)spaceIDsListerner, true);
        this.logger.log(Level.INFO, Messages.HazelcastSpaceRepository_1);
    }

    @Pure
    protected Logger createLogger(LoggingService loggingService) {
        return loggingService.getKernelModuleLogger(Messages.HazelcastSpaceRepository_5);
    }

    protected <S extends Space> S createSpaceFirstInstance(Class<? extends SpaceSpecification<S>> spec, SpaceID spaceID, Object[] creationParams) {
        Context localContext = this.contextService.getContext(spaceID.getContextID());
        if (localContext == null) {
            this.logger.log(Level.SEVERE, Messages.HazelcastSpaceRepository_2);
        }
        this.spaceIDs.putIfAbsent((Object)spaceID, (Object)creationParams);
        String topicName = HazelcastEventTransportService.getTopicNameFromSpaceID(spaceID);
        this.logger.log(Level.INFO, MessageFormat.format(Messages.HazelcastSpaceRepository_3, spaceID, topicName));
        this.availableTopicsName.add((Object)topicName);
        return (S)super.createSpaceFirstInstance(spec, spaceID, creationParams);
    }

    protected <S extends Space> S ensureLocalSpaceDefinition(SpaceID id, Object[] initializationParameters) {
        Space _xifexpression = null;
        boolean _hasSpace = this.hasSpace(id.getID());
        if (!_hasSpace) {
            Class _spaceSpecification;
            Space _xblockexpression = null;
            Class spec = _spaceSpecification = id.getSpaceSpecification();
            _xifexpression = _xblockexpression = super.createSpace(id, spec, initializationParameters);
        }
        return (S)_xifexpression;
    }

    protected void removeLocalSpaceDefinition(SpaceID id, boolean isLocalDestruction) {
        UUID _contextID = id.getContextID();
        UUID _iD = id.getID();
        String topicName = "io.sarl.topics.space." + String.valueOf(_contextID) + "." + String.valueOf(_iD);
        this.logger.log(Level.INFO, MessageFormat.format(Messages.HazelcastSpaceRepository_4, topicName));
        this.availableTopicsName.remove((Object)topicName);
        super.removeSpaceIfEmpty(id.getID());
    }

    protected void removeLocalSpaceDefinitions() {
        this.removeEmptySpaces();
    }

    protected void destroyThreadUnsafe() {
        super.destroyThreadUnsafe();
        this.spaceIDs.clear();
        this.spaceIDs.removeEntryListener(this.spaceIDsListernerID);
    }

    @Pure
    @SyntheticMember
    @SarlSourceCode(value="null")
    private static Map $DEFAULT_VALUE$NEW_0() {
        return null;
    }

    @Pure
    @SyntheticMember
    @SarlSourceCode(value="null")
    private static IMap $DEFAULT_VALUE$NEW_1() {
        return null;
    }

    @DefaultValueUse(value="io.bootique.di.Injector,io.sarl.sre.janus.services.executor.ExecutorService,io.sarl.sre.janus.services.logging.LoggingService,io.sarl.sre.janus.boot.configs.SreConfig,io.sarl.sre.janus.spaces.SreSpaceSpecificationFactory,io.sarl.sre.janus.services.context.ContextService,jakarta.inject.Provider,com.hazelcast.core.HazelcastInstance,java.util.Map,com.hazelcast.map.IMap")
    @SyntheticMember
    public HazelcastSpaceRepository(Injector injector, ExecutorService executor, LoggingService loggingService, SreConfig config, SreSpaceSpecificationFactory specificationFactory, ContextService icontextService, Provider<Factories> factories, HazelcastInstance iHazelcastInstance) {
        this(injector, executor, loggingService, config, specificationFactory, icontextService, factories, iHazelcastInstance, HazelcastSpaceRepository.$DEFAULT_VALUE$NEW_0(), (IMap<SpaceID, Object[]>)HazelcastSpaceRepository.$DEFAULT_VALUE$NEW_1());
    }

    @DefaultValueUse(value="io.bootique.di.Injector,io.sarl.sre.janus.services.executor.ExecutorService,io.sarl.sre.janus.services.logging.LoggingService,io.sarl.sre.janus.boot.configs.SreConfig,io.sarl.sre.janus.spaces.SreSpaceSpecificationFactory,io.sarl.sre.janus.services.context.ContextService,jakarta.inject.Provider,com.hazelcast.core.HazelcastInstance,java.util.Map,com.hazelcast.map.IMap")
    @SyntheticMember
    public HazelcastSpaceRepository(Injector injector, ExecutorService executor, LoggingService loggingService, SreConfig config, SreSpaceSpecificationFactory specificationFactory, ContextService icontextService, Provider<Factories> factories, HazelcastInstance iHazelcastInstance, IMap<SpaceID, Object[]> internalStructure1) {
        this(injector, executor, loggingService, config, specificationFactory, icontextService, factories, iHazelcastInstance, HazelcastSpaceRepository.$DEFAULT_VALUE$NEW_0(), internalStructure1);
    }

    @DefaultValueUse(value="io.bootique.di.Injector,io.sarl.sre.janus.services.executor.ExecutorService,io.sarl.sre.janus.services.logging.LoggingService,io.sarl.sre.janus.boot.configs.SreConfig,io.sarl.sre.janus.spaces.SreSpaceSpecificationFactory,io.sarl.sre.janus.services.context.ContextService,jakarta.inject.Provider,com.hazelcast.core.HazelcastInstance,java.util.Map,com.hazelcast.map.IMap")
    @SyntheticMember
    public HazelcastSpaceRepository(Injector injector, ExecutorService executor, LoggingService loggingService, SreConfig config, SreSpaceSpecificationFactory specificationFactory, ContextService icontextService, Provider<Factories> factories, HazelcastInstance iHazelcastInstance, Map<UUID, SpaceRepository.SpaceDescription> internalStructure0) {
        this(injector, executor, loggingService, config, specificationFactory, icontextService, factories, iHazelcastInstance, internalStructure0, (IMap<SpaceID, Object[]>)HazelcastSpaceRepository.$DEFAULT_VALUE$NEW_1());
    }

    @Pure
    @SyntheticMember
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        HazelcastSpaceRepository other = (HazelcastSpaceRepository)((Object)obj);
        if (!Objects.equals(this.spaceIDsListernerID, other.spaceIDsListernerID)) {
            return false;
        }
        return super.equals(obj);
    }

    @Pure
    @SyntheticMember
    public int hashCode() {
        int result = super.hashCode();
        int prime = 31;
        result = 31 * result + Objects.hashCode(this.spaceIDsListernerID);
        return result;
    }

    @Pure
    public HazelcastInstance getHazelcastInstance() {
        return this.hazelcastInstance;
    }
}

